package MusicLandscape.util;

import java.util.Objects;

/**
 * This class represents the concept of matching an object by some string pattern.
 * <p>
 * The pattern is a simple string. Null patterns are not accepted.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since LabWork
 */
abstract public class MyStringMatcher<T> extends MyMatcher<T> implements ConsoleScanable {
    /**
     * The pattern to match a string Track field.
     */
    protected String pattern;

    /**
     * The prompt displayed for changing this matcher's pattern.
     */
    protected String prompt = "enter pattern";

    /**
     * Creates a Matcher object with a specified pattern.
     *
     * @param pat the pattern of this matcher
     */
    public MyStringMatcher(String pat) {
        super(pat);

        if (pat == null) {
            throw new NullPointerException(getClass().getName() + " does not accept null as pattern!");
        }
    }

    /**
     * Sets the pattern of this matcher.
     * <p>
     * Null is not accepted.
     *
     * @param pat the pattern to set
     */
    @Override
    public void setPattern(String pat) {
        if (pat == null) {
            return;
        }

        pattern = pat;
    }

    /**
     * Gets the pattern of this matcher.
     * <p>
     * The pattern is returned in a format that is considered valid in setPattern.
     *
     * @return the pattern
     */
    @Override
    public String getPattern() {
        return pattern;
    }

    /**
     * Interactively modify this matcher.
     *
     * @return whether this object was altered or not
     */
    @Override
    public boolean scan() {
        String pattern = ConsoleScanner.nonEmptyString.scan(prompt);

        if (pattern != null) {
            String before = getPattern();
            setPattern(pattern);
            return !Objects.equals(before, getPattern());
        }

        return false;
    }
}
